<?php
/**
 * Plugin Name: ChatAzon A.I.
 * Description: Start chat with A.I. to find the best affiliate products to promote from Amazon.com based on keywords that you submit.
 * Plugin URI: https://wpthemeplugin.com/
 * Author: Leo BCBiz (WpThemePlugin.com)
 * Version: 1.0.3
 * Author URI: https://wpthemeplugin.com/
 * Requires at least: 5.6
 * Requires PHP: 7.0
*/
require 'kernl-update-checker/kernl-update-checker.php';
//$MyUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    //'https://kernl.us/api/v1/updates/chatazon9a4eb0ba0dbcdbc2c656ae/',
    //__FILE__,
    //'chatazon-ai-wtp'
//);
if ( ! function_exists( 'wtp_custom_curl_timeout' ) ) {
    add_action('http_api_curl', 'wtp_custom_curl_timeout', 9999, 1);
    function wtp_custom_curl_timeout( $handle ){
	    curl_setopt( $handle, CURLOPT_CONNECTTIMEOUT, 60 );
	    curl_setopt( $handle, CURLOPT_TIMEOUT, 60 );
    }
}

if ( ! function_exists( 'wtp_custom_http_request_timeout' ) ) {
    add_filter( 'http_request_timeout', 'wtp_custom_http_request_timeout', 9999 );
    function wtp_custom_http_request_timeout( $timeout_value ) {
	    return 60;
    }
}

if ( ! function_exists( 'wtp_custom_http_request_args' ) ) {
    add_filter('http_request_args', 'wtp_custom_http_request_args', 9999, 1);
    function wtp_custom_http_request_args( $r ){
	    $r['timeout'] = 60;
	    return $r;
    }
}
class ChatAzonAIWTP {
	private $chatazon_ai_wtp_options;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'chatazon_ai_wtp_add_plugin_page' ) );
		add_action( 'admin_init', array( $this, 'chatazon_ai_wtp_page_init' ) );
	}

	public function chatazon_ai_wtp_add_plugin_page() {
		add_options_page(
			'ChatAzon AI by WPThemePlugin.com', // page_title
			'ChatAzon A.I.', // menu_title
			'manage_options', // capability
			'chatazon-ai-wtp', // menu_slug
			array( $this, 'chatazon_ai_wtp_create_admin_page' ) // function
		);
	}

	public function chatazon_ai_wtp_create_admin_page() {
		$this->chatazon_ai_wtp_options = get_option( 'chatazon_ai_wtp_option_name' ); ?>
		
		<style>
        .chatazon-userpage {
            background: #fff;
            padding: 15px 30px;
            margin: 20px 15px;
            max-width: 800px;
            box-shadow: #3e8b72 0px 0px 0px 1px;
            border-radius:10px;
        }
        
        .chatazon-userpage p {
            font-size: 15px;
            color: #4e4e4e;
        }
        </style>

        <div class="wrap"></div>
		<div class="chatazon-userpage">
			<h2>ChatAzon AI</h2>
			<span>
			    <a href="https://wpthemeplugin.com" style="color: #fff; text-decoration: none; font-size: 10px; background: #6aa84f; padding: 4px 10px; border-radius: 2px;" target="_blank">CODED BY WPTHEMEPLUGIN.COM</a>
			</span>
			<div style="margin-top:20px;border-bottom:1px solid #ccc;">
			<p><strong>How to Use This Plugin:</strong></p>
			<p>Enter a keyword on the field below, and click the "Find Products" button.</p><p>After that Wait a few seconds, and the plugin will display the most popular products from Amazon.com along with their rating and scores. The higher the score, the better it is to be promoted.</p>
			</div>
			
			<?php
			    include 'chatazon-ai-section.php';
		    ?>
			
		</div>
	<?php }

	public function chatazon_ai_wtp_page_init() {
		register_setting(
			'chatazon_ai_wtp_option_group', // option_group
			'chatazon_ai_wtp_option_name', // option_name
			array( $this, 'chatazon_ai_wtp_sanitize' ) // sanitize_callback
		);

		add_settings_section(
			'chatazon_ai_wtp_setting_section', // id
			'Settings', // title
			array( $this, 'chatazon_ai_wtp_section_info' ), // callback
			'chatazon-ai-wtp-admin' // page
		);

		add_settings_field(
			'amazon_country_0', // id
			'Amazon Country', // title
			array( $this, 'amazon_country_0_callback' ), // callback
			'chatazon-ai-wtp-admin', // page
			'chatazon_ai_wtp_setting_section' // section
		);
	}

	public function chatazon_ai_wtp_sanitize($input) {
		$sanitary_values = array();
		if ( isset( $input['amazon_country_0'] ) ) {
			$sanitary_values['amazon_country_0'] = sanitize_text_field( $input['amazon_country_0'] );
		}

		return $sanitary_values;
	}

	public function chatazon_ai_wtp_section_info() {
		
	}

	public function amazon_country_0_callback() {
		printf(
			'<input class="regular-text" type="text" name="chatazon_ai_wtp_option_name[amazon_country_0]" id="amazon_country_0" value="%s">',
			isset( $this->chatazon_ai_wtp_options['amazon_country_0'] ) ? esc_attr( $this->chatazon_ai_wtp_options['amazon_country_0']) : ''
		);
	}

}
if ( is_admin() )
	$chatazon_ai_wtp = new ChatAzonAIWTP();
