<?php
/**
 * Plugin Name: KeywordHub WTP
 * Description: In-depth keywords research to find profitable long-tail keywords faster.
 * Plugin URI: https://wpthemeplugin.com/
 * Author: Leo (WpThemePlugin.com)
 * Version: 1.0.5
 * Author URI: https://wpthemeplugin.com/
 * Requires at least: 5.6
 * Requires PHP: 7.0
*/
require 'kernl-update-checker/kernl-update-checker.php';
$MyUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    'https://kernl.us/api/v1/updates/648fdec17c7a5e0d4b602fed/',
    __FILE__,
    'kwhub-wtp'
);
if ( ! function_exists( 'wtp_custom_curl_timeout' ) ) {
    add_action('http_api_curl', 'wtp_custom_curl_timeout', 9999, 1);
    function wtp_custom_curl_timeout( $handle ){
	    curl_setopt( $handle, CURLOPT_CONNECTTIMEOUT, 60 );
	    curl_setopt( $handle, CURLOPT_TIMEOUT, 60 );
    }
}

if ( ! function_exists( 'wtp_custom_http_request_timeout' ) ) {
    add_filter( 'http_request_timeout', 'wtp_custom_http_request_timeout', 9999 );
    function wtp_custom_http_request_timeout( $timeout_value ) {
	    return 60;
    }
}

if ( ! function_exists( 'wtp_custom_http_request_args' ) ) {
    add_filter('http_request_args', 'wtp_custom_http_request_args', 9999, 1);
    function wtp_custom_http_request_args( $r ){
	    $r['timeout'] = 60;
	    return $r;
    }
}
require 'kwhub-save.php';
require 'kwhub-voting-submit.php';

class KeywordPressWTP {
	private $keywordpress_wtp_options;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'keywordpress_wtp_add_plugin_page' ) );
		add_action( 'admin_init', array( $this, 'keywordpress_wtp_page_init' ) );
	}

	public function keywordpress_wtp_add_plugin_page() {
		add_menu_page(
			'KeywordHub WP Plugin', // page_title
			'KeywordHub', // menu_title
			'manage_options', // capability
			'keywordhub-wtp', // menu_slug
			array( $this, 'keywordpress_wtp_create_admin_page' ), // function
			'dashicons-search', // icon_url
			60 // position
		);
	}

	public function keywordpress_wtp_create_admin_page() {
		$this->keywordpress_wtp_options = get_option( 'keywordpress_wtp_option_name' ); ?>
		
		<style>
        .kwpress-userpage {
            background: #fff;
            padding: 30px 30px 20px;
            margin: 20px 15px;
            max-width: 900px;
            box-shadow: #ccc 0px 0px 0px 1px;
            border-radius:8px;
        }
        
        .kwspress-userpage p {
            font-size: 15px;
            color: #4e4e4e;
        }
        .kwpress-button {
            padding:4px 10px;
            font-size:16px;
        }
        .kwpress-button:hover {
            cursor:pointer;
        }
        
        .kwpress-surveybutton {
            padding:4px 10px;
            font-size:14px;
        }
        .kwpress-surveybutton:hover {
            cursor:pointer;
        }
        
        .kwpress-savebutton,
        .kwpress-newsbutton {
            padding:4px 10px;
            font-size:13px;
            margin-bottom:5px;
        }
        .kwpress-savebutton:hover,
        .kwpress-newsbutton:hover{
            cursor:pointer;
        }
        .kwpress-savesection {
            margin-top:25px;
            margin-bottom:10px;
            text-align:right;
            max-width:98%;
        }
        .kwpress-savesection .dashicons {
            font-size:13px;
            width:13px;
            height:13px;
            vertical-align:middle;
        }
        
        .kwpress-none,
        .kwpress-savenone,
        .kwpress-newsnone {
            display: none;
        }
        
        .kwpress-newsresultbox {
            text-align:left !important;
            margin-top:15px;
            margin-bottom:15px;
        }
        table.kwpress-table {
            margin-top:20px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.15);
            font-size:15px;
            border:1px solid #ccc;
            border-collapse: separate;
            border-radius: 1em;
            border-spacing: 0;
            animation-name: kwpressopacity;
            animation-duration: 3s;
            margin-bottom:25px;
            max-width:98%;
        }
        
        @keyframes kwpressopacity {
            from {opacity: 0.5;}
            to {opacity: 1;}
        }
        .kwpress-userpage th,
        .kwpress-userpage td {
            font-size:15px;
            padding:14px 20px;
        }
        .kwpress-userpage th {
            color:#fff;
            background:#009879;
            text-align: left;
        }
        
        table.kwpress-table th:not(:last-child),
        table.kwpress-table td:not(:last-child) {
            border-right: 1px solid #ccc;
        }
        
        table.kwpress-table>thead>tr:not(:last-child)>th,
        table.kwpress-table>thead>tr:not(:last-child)>td,
        table.kwpress-table>tbody>tr:not(:last-child)>th,
        table.kwpress-table>tbody>tr:not(:last-child)>td,
        table.kwpress-table>tfoot>tr:not(:last-child)>th,
        table.kwpress-table>tfoot>tr:not(:last-child)>td,
        table.kwpress-table>tr:not(:last-child)>td,
        table.kwpress-table>tr:not(:last-child)>th,
        table.kwpress-table>thead:not(:last-child),
        table.kwpress-table>tbody:not(:last-child),
        table.kwpress-table>tfoot:not(:last-child) {
            border-bottom: 1px solid #ccc;
        }
        
        table.kwpress-table {
            --border: 1px solid #ccc;
            border-radius: 10px;
            border-spacing: 0;
            border-collapse: separate;
            border: var(--border);
            overflow: hidden;
        }

        table.kwpress-table td:not(:last-child) {
            border-right: var(--border);
        }

        table.kwpress-table>thead>tr:not(:last-child)>th,
        table.kwpress-table>thead>tr:not(:last-child)>td,
        table.kwpress-table>tbody>tr:not(:last-child)>th,
        table.kwpress-table>tbody>tr:not(:last-child)>td,
        table.kwpress-table>tfoot>tr:not(:last-child)>th,
        table.kwpress-table>tfoot>tr:not(:last-child)>td,
        table.kwpress-table>tr:not(:last-child)>td,
        table.kwpress-table>tr:not(:last-child)>th,
        table.kwpress-table>thead:not(:last-child),
        table.kwpress-table>tbody:not(:last-child),
        table.kwpress-table>tfoot:not(:last-child) {
            border-bottom: var(--border);
        }
        
        .kwpress-table tbody tr:nth-of-type(even) {
            background-color: #f3f3f3;
        }

        .kwpress-table tbody tr:last-of-type {
            border-bottom: 2px solid #00b8e8;
        }
        
        table.kwpress-table tr:hover {
            background-color:#e5f1ef;
        }
        </style>
        <?php
        $loadingbar = plugin_dir_url( __FILE__ ).'images/kwpress-loadingbar-4.gif';
        ?>
		<div class="wrap kwpress-userpage">
		    
		    <style>
		        .bar-lgrey {
		            background-color:#dedede;
		        }
		        .ibar-green-low {
		            background-color:#4CAF50;
		            height:14px;
		            width:25%;
		        }
		        .ibar-green-medium {
		            background-color:#4CAF50;
		            height:14px;
		            width:50%;
		        }
		        .ibar-green-high {
		            background-color:#4CAF50;
		            height:14px;
		            width:85%;
		        }
		        
		        .td-comp {
		            max-width:60px !important;
		        }
		        .td-trend {
		            max-width:200px !important;
		            min-width:200px !important;
		            overflow: auto;
                    white-space: nowrap;
		        }
		        .td-trend span {
		            display:inline-block;
		            min-height:20px;
		            padding:2px 0;
		            font-size:13px;
		            border-top : solid 3px transparent;
                    border-bottom : solid 3px transparent;
		        }
		    </style>
		    

			<div style="font-size:24px;color:#5e5e5e;border-bottom:1px solid #e0e0e0;padding-bottom:10px;"><span class="dashicons dashicons-search"></span> KEYWORDHUB WP PLUGIN</div>
			
			<?php
			if ( is_plugin_active( 'kwhub-platinum/kwhub-platinum.php' ) ) {
			?>
			<div style="margin-top:10px;">
			    <a href="https://wpthemeplugin.com/userguide-wpkeywordhub/" style="color: #fff; text-decoration: none; font-size: 10px; background: #00bc7d; padding: 4px 10px; border-radius: 2px;" target="_blank">USER GUIDE</a> <a href="https://wpthemeplugin.com/" style="color: #fff; text-decoration: none; font-size: 10px; background: #ff8100; padding: 4px 10px; border-radius: 2px;" target="_blank">CODED BY WPTHEMEPLUGIN</a> <img src="<?php echo $loadingbar; ?>" width="1" height="1" />
			</div>
			<?php
			} else {
			?>
			<div style="margin-top:10px;">
			    <a href="https://1clickwptools.com/kwhub-platinum/" style="color: #fff; text-decoration: none; font-size: 10px; background: #ff8100; padding: 4px 10px; border-radius: 2px;" target="_blank">UPGRADE TO PLATINUM</a> <span style="padding-left:5px;"></span> <a href="https://wpthemeplugin.com/userguide-wpkeywordhub/" style="color: #fff; text-decoration: none; font-size: 10px; background: #00bc7d; padding: 4px 10px; border-radius: 2px;" target="_blank">USER GUIDE</a> <img src="<?php echo $loadingbar; ?>" width="1" height="1" />
			</div>
			<?php
			}
			?>
			
			<div style="margin-top:35px;">
                <label for="kwpress-userkeyword" style="display:inline-block;width:200px;margin-right:10px;font-size:16px;">Main/Parent Keyword:</label>
                <input class="regular-text" placeholder="Example: Weight Loss" type="text" name="kwpress-userkeyword" id="kwpress-userkeyword" required>
            </div>
            
            <div style="margin-top:20px;">
                <label for="kwpress-usermarket" style="display:inline-block;width:200px;margin-right:10px;font-size:16px;">Target Market:</label>

                <select name="kwpress-usermarket" id="kwpress-usermarket">
                    <option value="kwpress-us">United States</option>
                    <option value="kwpress-au">Australia</option>
                    <option value="kwpress-ca">Canada</option>
                    <option value="kwpress-in">India</option>
                    <option value="kwpress-gb">United Kingdom</option>
                    <option value="kwpress-de">Germany</option>
                </select>
            </div>
            
            <div style="margin-top:20px;">
                <label for="kwpress-userserver" style="display:inline-block;width:200px;margin-right:10px;font-size:16px;">KeywordHub Server:</label>

                <select name="kwpress-userserver" id="kwpress-userserver">
                    <option value="kwpress-firstserver">Main Server</option>
                    <option value="kwpress-secondserver">Secondary Server</option>
                </select>
                <div style="margin-top:15px;font-size:14px;"><em>(if the Main Server is down, choose the other server)</em></div>
            </div>
            
            <div style="margin-top:30px;margin-bottom:20px;display:flex;align-items:baseline;">
                <button type="button" id="kwpress-btn" class="kwpress-button"><span class="dashicons dashicons-search"></span> <span>Find Keywords</span></button>
            </div>
            
            

            <div id="kwpress-loading"></div>
            <div id="kwpress-box" class="kwpress-none">
                
                <?php
                $kwhsurvey_getvote = get_option( 'kwhub_survey_vote' );
            
                if($kwhsurvey_getvote) {
                
                } else {
                    //include 'kwhub-voting.php';
                }
            
                ?>
                
                <div class="kwpress-savesection">
                    <button type="button" id="kwpress-savebtn" class="kwpress-savebutton"><span class="dashicons dashicons-download"></span> <span>Save Results</span></button>
                    
                    <button type="button" id="kwpress-newsbtn" class="kwpress-newsbutton"><span class="dashicons dashicons-admin-site"></span> <span>Current Keyword News</span></button>
                
                    <div id="kwpress-saveloading"></div>
                    <div id="kwpress-savebox" class="kwpress-savenone">
                        <div id="kwpress-saveresultbox"></div>
                    </div>
                    
                    <div id="kwpress-newsloading"></div>
                    <div id="kwpress-newsbox" class="kwpress-newsnone">
                        <div id="kwpress-newsresultbox" class="kwpress-newsresultbox"></div>
                    </div>
                </div><!-- SAVE SECTION -->
                <div id="kwpress-resultbox"></div>
            </div>
            
            
            <!-- FIND KEYWORD -->
            <script>
            document.getElementById( 'kwpress-btn' ).addEventListener( 'click', function ( event ) {
		    
		    event.preventDefault();
		    
		    var txtcheck = document.getElementById('kwpress-userkeyword').value;

            if(txtcheck.length<5) {
                window.alert ("Enter main keyword first, min 5 characters.");
            } else {
			
		    var topicInput = document.getElementById( 'kwpress-userkeyword' );
		    var mrktInput = document.getElementById( 'kwpress-usermarket' );
		    
		    var serverInput = document.getElementById( 'kwpress-userserver' );
		    
		    var box = document.getElementById( 'kwpress-box' );
		    var postbox = document.getElementById('kwpress-resultbox');
			
		    var loadingpict = document.getElementById( 'kwpress-loading' );
		    loadingpict.innerHTML = '<img src="<?php echo $loadingbar; ?>" alt="Importing..." width="400" />';
		    loadingpict.classList = 'downloading';
			
		    var ajaxurl = '<?php echo admin_url( 'admin-ajax.php' ); ?>';
		    var xhttp = new XMLHttpRequest();
			
		    var formData = new FormData();
		    
		    if (serverInput.value === 'kwpress-secondserver') {
                formData.append( 'action', 'kwpwtp_backupaction' );
            } else {
                formData.append( 'action', 'kwpwtp_submitaction' );
            }
		    
		    //formData.append( 'action', 'kwpwtp_submitaction' );
		    formData.append( 'kwmain', topicInput.value );
		    formData.append( 'kwmarket', mrktInput.value );
			
		    xhttp.open( "POST", ajaxurl );
		    xhttp.send( formData );
			
		    xhttp.onreadystatechange = function () {
			if ( this.readyState === 4 && this.status === 200 ) {
				var data = JSON.parse( this.responseText );
				if ( data.success === true ) {
					loadingpict.classList.add( 'kwpress-display' );
					loadingpict.innerHTML = '';
					box.classList.remove( 'kwpress-none' );
					box.classList.add( 'kwpress-display' );
					postbox.innerHTML = data.kwpfincontent;
				} else {
					loadingpict.classList.add( 'error' );
					loadingpict.innerHTML = data.data;
				}
			}
		    };
            }//END CHECK IF EMPTY
		    } );
            </script>

            <?php
                include 'kwhub-section-import.php';
                include 'kwhub-section-news.php';
            ?>
			
		</div>
	<?php }

	public function keywordpress_wtp_page_init() {
		register_setting(
			'keywordpress_wtp_option_group', // option_group
			'keywordpress_wtp_option_name', // option_name
			array( $this, 'keywordpress_wtp_sanitize' ) // sanitize_callback
		);

		add_settings_section(
			'keywordpress_wtp_setting_section', // id
			'Settings', // title
			array( $this, 'keywordpress_wtp_section_info' ), // callback
			'keywordpress-wtp-admin' // page
		);

		add_settings_field(
			'number_of_content_0', // id
			'Number of Content', // title
			array( $this, 'number_of_content_0_callback' ), // callback
			'keywordpress-wtp-admin', // page
			'keywordpress_wtp_setting_section' // section
		);
	}

	public function keywordpress_wtp_sanitize($input) {
		$sanitary_values = array();
		if ( isset( $input['number_of_content_0'] ) ) {
			$sanitary_values['number_of_content_0'] = sanitize_text_field( $input['number_of_content_0'] );
		}

		return $sanitary_values;
	}

	public function keywordpress_wtp_section_info() {
		
	}

	public function number_of_content_0_callback() {
		printf(
			'<input class="regular-text" type="text" name="keywordpress_wtp_option_name[number_of_content_0]" id="number_of_content_0" value="%s">',
			isset( $this->keywordpress_wtp_options['number_of_content_0'] ) ? esc_attr( $this->keywordpress_wtp_options['number_of_content_0']) : ''
		);
	}

}
if ( is_admin() )
	$keywordpress_wtp = new KeywordPressWTP();

