<?php

function gemibrainvision_api_send() {
    
    require_once(ABSPATH . "wp-admin" . '/includes/image.php');
    require_once(ABSPATH . "wp-admin" . '/includes/file.php');
    require_once(ABSPATH . "wp-admin" . '/includes/media.php');
    
    $gbai_topic = $_POST['gemibrainuserchat'];
    $gbai_topic = sanitize_textarea_field($gbai_topic);
    $gbai_topic = trim($gbai_topic);
    
    $gbai_engine = $_POST['gemibrainuserengine'];
    $gbai_engine = sanitize_text_field($gbai_engine);
    
    $gbai_temp = $_POST['gemibrainusertemp'];
    $gbai_temp = sanitize_text_field($gbai_temp);
    
    $gbai_imgfile = $_FILES['gemibrainuserfile'];
    $upload_overrides = array( 'test_form' => false );
    
    if ( is_wp_error( $gbai_topic ) ) {
    
    } else {
    
        $uploaded_file = wp_handle_upload($gbai_imgfile, $upload_overrides);
        
        $file_name_and_location = $uploaded_file['file'];
        $file_title = sanitize_file_name( wp_basename( $gbai_imgfile['name'] ) );
        $file_type = wp_check_filetype( $file_name_and_location );
    
        $attachment = array(
            'post_mime_type' => $file_type['type'],
            'post_title' => $file_title,
            'post_content' => '',
            'post_status' => 'inherit'
        );

        $attach_id = wp_insert_attachment( $attachment, $file_name_and_location );
        $attach_data = wp_generate_attachment_metadata( $attach_id, $file_name_and_location );
        wp_update_attachment_metadata( $attach_id,  $attach_data );
    
        $attach_url = wp_get_attachment_url( $attach_id );
    }
    
    if ($gbai_temp == "1") {
        $gbai_fintemp = "0.1";
    } elseif ($gbai_temp == "2") {
        $gbai_fintemp = "0.2";
    } elseif ($gbai_temp == "3") {
        $gbai_fintemp = "0.3";
    } elseif ($gbai_temp == "4") {
        $gbai_fintemp = "0.4";
    } elseif ($gbai_temp == "5") {
        $gbai_fintemp = "0.5";
    } elseif ($gbai_temp == "6") {
        $gbai_fintemp = "0.6";
    } elseif ($gbai_temp == "7") {
        $gbai_fintemp = "0.7";
    } elseif ($gbai_temp == "8") {
        $gbai_fintemp = "0.8";
    } else {
        $gbai_fintemp = "0.9";
    }
    
    $gbai_token = $_POST['gemibrainusertoken'];
    $gbai_token = sanitize_text_field($gbai_token);
    
    if ($gbai_engine === 'option-2') {
        
        //USE GEMINI AI
        //START API CALL
        $gemini_apikey = 'AIzaSyC0qG_muJJHs_02o0G3zxjYQz_Tcrm8qhY';
        $gemini_wtpkey = 'AIzaSyC4iVp-EiaO9531NKT8IRjvSgVLwwb6Qy4';
        
        $arr_gmnapi = array( 'AIzaSyC0qG_muJJHs_02o0G3zxjYQz_Tcrm8qhY', 'AIzaSyC4iVp-EiaO9531NKT8IRjvSgVLwwb6Qy4' );
 
        // Use array_rand function to returns random key
        $bizmt_randkey = array_rand($arr_gmnapi);
        $bizmt_gptkey = $arr_gmnapi[$bizmt_randkey];
    
        $url = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash-lite:generateContent?key='.$bizmt_gptkey;
        
        //$image_url = 'https://upload.wikimedia.org/wikipedia/commons/thumb/9/99/Elon_Musk_Colorado_2022_%28cropped2%29.jpg/330px-Elon_Musk_Colorado_2022_%28cropped2%29.jpg';
        $image = file_get_contents($attach_url);
        $image_base64 = base64_encode($image);

        $body = array(
            "contents" => array(
                array(
                    "parts" => array(
                        array(
                            "text" => $gbai_topic
                        ),
                        array(
                            'inline_data' => array( 
                                'mime_type' => 'image/jpeg', 
                                'data' => $image_base64
                                )
                        )
                    )
                )
            ),
            "generationConfig" => array(
                "temperature" => $gbai_fintemp,
                "topK" => 1,
                "topP" => 1,
                "maxOutputTokens" => $gbai_token,
                "stopSequences" => array()
            ),
            "safetySettings" => array(
                array("category" => "HARM_CATEGORY_HARASSMENT", "threshold" => "BLOCK_MEDIUM_AND_ABOVE"),
                array("category" => "HARM_CATEGORY_HATE_SPEECH", "threshold" => "BLOCK_MEDIUM_AND_ABOVE"),
                array("category" => "HARM_CATEGORY_SEXUALLY_EXPLICIT", "threshold" => "BLOCK_MEDIUM_AND_ABOVE"),
                array("category" => "HARM_CATEGORY_DANGEROUS_CONTENT", "threshold" => "BLOCK_MEDIUM_AND_ABOVE"),
            )
        );

        $headers = array(
            'Content-Type' => 'application/json'
        );

        $args = array(
            'body'        => json_encode($body),
            'headers'     => $headers,
            'multipart' => true,
            'data_format' => 'body'
        );

        $response = wp_remote_post( $url, $args );
    
        //END API CALL
    
        $rp_getapibody = wp_remote_retrieve_body( $response );
        $rp_apiresult = json_decode( $rp_getapibody );
    
        $finresult = $rp_apiresult->candidates[0]->content->parts[0]->text;
        
    } else {
        
        //USE CHATGPT
        // Declare an associative array
        $arr_api = array( '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', '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' );
 
        // Use array_rand function to returns random key
        $bizmt_randkey = array_rand($arr_api);
        $bizmt_gptkey = $arr_api[$bizmt_randkey];
        
        $rp_apicall = wp_remote_post(
            'https://api.openai.com/v1/chat/completions',
		        array(
			        'headers' => array(
				        'Content-Type' => 'application/json',
				        'Authorization' => 'Bearer '.$bizmt_gptkey,
			        ),
			        'body' => json_encode(
                        array(
                            'model' => 'gpt-4o-mini',
                            'temperature' => 0.6,
                            'messages' => array(
                                array(
                                    'role' => 'user',
                                    'content' => $gbai_topic
                                )
                            )
                        )
                    ),
			    'method'      => 'POST',
			    'data_format' => 'body',
		    )
	    );
	    
        $rp_getapibody = wp_remote_retrieve_body( $rp_apicall );
        $rp_apiresult = json_decode( $rp_getapibody );
        $finresult = $rp_apiresult->choices[0]->message->content;
        $finresult = trim($finresult);
        
    }//END if ($gbai_engine === 'option-1')
    
    
    
    $bizmt_myfincontent = esc_html($finresult);
    
    $bizmt_wpautop = wpautop($bizmt_myfincontent);
    
    $finresult = '<div class="gemibrain-response">
            <div class="gemibrain-imgchat">
                <img src="https://d2c136330chs5t.cloudfront.net/AITools/7-GemiBrainAI/gemibrainai-icon-2.png">
            </div>
            <div class="gemibrain-chat tri-right left-top">
                '.$bizmt_wpautop.'
            </div>
            <div style="clear:both;"></div>
        </div>';
    
    if ( is_wp_error( $response ) ) {
        wp_send_json_error( $response->get_error_message() );
    } else {
        wp_send_json( array( 'success' => true, 'humanfindata' => __( 'Request Success.', 'gemibrainai-wtp' ), 'tfallcontent' => $finresult ) );
    }
    
    
    wp_die();
}

add_action( 'wp_ajax_gemibrain_vision', 'gemibrainvision_api_send' );
add_action( 'wp_ajax_nopriv_gemibrain_vision', 'gemibrainvision_api_send' );
