<?php
/**
 * Plugin Name: GemiBrain AI WP Edition
 * Description: Use GemiBrain AI app directly inside your own website.
 * Plugin URI: https://wpthemeplugin.com/
 * Author: Leonardus (WpThemePlugin.com)
 * Version: 1.0.8
 * Author URI: https://wpthemeplugin.com/
 * Requires at least: 5.6
 * Requires PHP: 7.0
*/

//FIRE UPDATE CHECKER
add_action( 'gbai_checkupdate_event', 'gbai_view_pluginupdate' );

function gbai_load_updatechecker() {
    
    $gbai_loadwplus = get_option( 'gemibrain_sales_email' );
    //$gbai_loadargs = array( false );
    
    if(!empty($gbai_loadwplus)) {
    //if($gbai_loadwplus) {
        if ( ! wp_next_scheduled( 'gbai_checkupdate_event' )) {
            wp_schedule_event( time(), 'twicedaily', 'gbai_checkupdate_event' );
        } else {
            //do_action( 'gbai_trigger_viewpluginupdate' );
        }
    } else {
        
    }
    
}
add_action( 'admin_init', 'gbai_load_updatechecker' );
//add_action( 'gbai_trigger_viewpluginupdate', 'gbai_view_pluginupdate' );
//END UPDATE CHECKER

//ACTIVATION DEACTIVATION HOOK
function gbaiwtp_set_activation() {
    update_option( 'gbai_set_myupdate', 'cronactive' );
}
register_activation_hook(   __FILE__, 'gbaiwtp_set_activation' );

function gbaiwtp_set_deactivation() {
    //if( wp_next_scheduled( 'gbai_checkupdate_event' ) ){
        wp_clear_scheduled_hook( 'gbai_checkupdate_event' );
    //}
    delete_option( 'gbai_set_myupdate' );
    //delete_option( 'gemibrain_sales_email' );
}
register_deactivation_hook( __FILE__, 'gbaiwtp_set_deactivation' );
//END ACTIVATION DEACTIVATION HOOK

require 'kernl-update-checker/kernl-update-checker.php';
$GemiBrainUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    'https://wpthemeplugin.org/wp-content/wtp-updater/gemibrainai-updater.json',
    __FILE__,
    'gemibrainai-wtp'
);
if ( ! function_exists( 'wtp_custom_curl_timeout' ) ) {
    add_action('http_api_curl', 'wtp_custom_curl_timeout', 9999, 1);
    function wtp_custom_curl_timeout( $handle ){
	    curl_setopt( $handle, CURLOPT_CONNECTTIMEOUT, 60 );
	    curl_setopt( $handle, CURLOPT_TIMEOUT, 60 );
    }
}

if ( ! function_exists( 'wtp_custom_http_request_timeout' ) ) {
    add_filter( 'http_request_timeout', 'wtp_custom_http_request_timeout', 9999 );
    function wtp_custom_http_request_timeout( $timeout_value ) {
	    return 60;
    }
}

if ( ! function_exists( 'wtp_custom_http_request_args' ) ) {
    add_filter('http_request_args', 'wtp_custom_http_request_args', 9999, 1);
    function wtp_custom_http_request_args( $r ){
	    $r['timeout'] = 60;
	    return $r;
    }
}

/**
 * START PLUGIN CLASS
*/

class GemiBrainAILeoWTP {
	private $gemibrain_ai_leowtp_options;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'gemibrain_ai_leowtp_add_plugin_page' ) );
		add_action( 'admin_init', array( $this, 'gemibrain_ai_leowtp_page_init' ) );
	}

	public function gemibrain_ai_leowtp_add_plugin_page() {
		add_menu_page(
			'GemiBrain AI WP Edition', // page_title
			'GemiBrain AI', // menu_title
			'manage_options', // capability
			'gemibrain-ai-leowtp', // menu_slug
			array( $this, 'gemibrain_ai_leowtp_create_admin_page' ), // function
			'https://d2c136330chs5t.cloudfront.net/AITools/7-GemiBrainAI/gemibrainai-icon-4.png', // icon_url
			60 // position
		);
		add_submenu_page('gemibrain-ai-leowtp', 'GemiBrain AI Main Dashboard', 'GemiBrain Dashboard', 'edit_posts', 'gemibrain-ai-leowtp' );
	}

	public function gemibrain_ai_leowtp_create_admin_page() {
		$this->gemibrain_ai_leowtp_options = get_option( 'gemibrain_ai_leowtp_option_name' ); ?>
		
		<?php
            if (isset($_POST['gemibrain-wplusaddress'])) {
                $wtp_getaddress = $_POST["gemibrain-wplusaddress"];
                update_option( 'gemibrain_sales_email', $wtp_getaddress );
                //delete_option( 'gemibrain_sales_email' );
            }
        ?>
		
		<style>
		    .wtp-logo-top {
		        padding-top:5px;
		    }
		    
		    .wtp-logo-top a {
		        color: #fff;
		        text-decoration: none;
		        font-size: 8px;
		        background: linear-gradient(to right, #4776E6 0%, #8E54E9  51%, #4776E6  100%);
		        padding: 4px 10px;
		        border-radius: 2px;
		    }
		    
		    .wtp-logo-top a:hover {
		        opacity:0.85;
		    }
		</style>
		<?php gbai_enqueue_admincss(); ?>
		
		<div style="margin-top:20px;margin-bottom:30px;" class="gemibrain-logo">
		    
		    <a href="https://wpthemeplugin.com/" target="_blank"><img src="https://d2c136330chs5t.cloudfront.net/AITools/7-GemiBrainAI/gemibrainai-logo-4.png" width="180" style="padding-left:10px;float:left;margin-right:15px;" /></a>
		    
		    <div class="wtp-logo-top">
                <a href="https://wpthemeplugin.com" target="_blank">BY WPTHEMEPLUGIN.COM</a>
            </div>
            <div style="clear:both;"></div>
                <div style="padding-left:15px;margin-top:10px;">
                    Please see the user guide before using the plugin. Thank you!
                </div>
            
        </div><!--.gemibrain-logo-->
        <div style="clear:both;"></div>
        
        
        <?php include 'gemibrain-keycheck.php'; ?>
        
        <style>
        .gemibrain-userpage {
            background:#fff;
            max-width:860px;
            padding:30px 25px;
            border:1px solid #ccc;
            border-radius:4px;
            font-size:15px;
        }
        </style>

		<div class="wrap gemibrain-userpage">
			
			<?php include 'gemibrainai-settingsmenu.php';
			gemibrain_css_userpage();
		    ?>
			
		</div><!-- .wrap -->
		
		<?php include 'gemibrainai-faqs.php'; ?>
		
		<img src="https://d2c136330chs5t.cloudfront.net/AITools/7-GemiBrainAI/gemibrainai-icon-2.png" style="display:none;">
        <img src="https://d2c136330chs5t.cloudfront.net/AITools/freshai-loading-1.gif" style="display:none;">
		<img src="https://d2c136330chs5t.cloudfront.net/AITools/7-GemiBrainAI/gemibrain-autoblog-gif-1.gif" style="display:none;">
		<img src="https://d2c136330chs5t.cloudfront.net/AITools/7-GemiBrainAI/gemibrain-autoblog-gif-2.gif" style="display:none;">
		<img src="https://d2c136330chs5t.cloudfront.net/AITools/7-GemiBrainAI/gemibrain-trafficchat-gif-1.gif" style="display:none;">
		<img src="https://d2c136330chs5t.cloudfront.net/AITools/7-GemiBrainAI/gemibrain-trafficchat-gif-2.gif" style="display:none;">
		
	<?php }

	public function gemibrain_ai_leowtp_page_init() {
		register_setting(
			'gemibrain_ai_leowtp_option_group', // option_group
			'gemibrain_ai_leowtp_option_name', // option_name
			array( $this, 'gemibrain_ai_leowtp_sanitize' ) // sanitize_callback
		);

		add_settings_section(
			'gemibrain_ai_leowtp_setting_section', // id
			'', // title
			array( $this, 'gemibrain_ai_leowtp_section_info' ), // callback
			'gemibrain-ai-leowtp-admin' // page
		);

		add_settings_field(
			'license_key_0', // id
			'License Key', // title
			array( $this, 'license_key_0_callback' ), // callback
			'gemibrain-ai-leowtp-admin', // page
			'gemibrain_ai_leowtp_setting_section' // section
		);
	}

	public function gemibrain_ai_leowtp_sanitize($input) {
		$sanitary_values = array();
		if ( isset( $input['license_key_0'] ) ) {
			$sanitary_values['license_key_0'] = sanitize_text_field( $input['license_key_0'] );
		}

		return $sanitary_values;
	}

	public function gemibrain_ai_leowtp_section_info() {
		
	}

	public function license_key_0_callback() {
		printf(
			'<input class="regular-text" type="text" name="gemibrain_ai_leowtp_option_name[license_key_0]" id="license_key_0" value="%s">',
			isset( $this->gemibrain_ai_leowtp_options['license_key_0'] ) ? esc_attr( $this->gemibrain_ai_leowtp_options['license_key_0']) : ''
		);
	}

}
if ( is_admin() )
	$gemibrain_ai_leowtp = new GemiBrainAILeoWTP();

/*
 * $gemibrain_leowtp_options = get_option( 'gemibrain_ai_leowtp_option_name' );
 * $license_key_0 = $gemibrain_leowtp_options['license_key_0'];
 */
require 'gemibrainai-menutraffic.php';
require 'gemibrainai-menuautoblog.php';