<?php
//GEMIBRAIN SETTINGS MENU
?>

<style>
.gemibrain-fe-section select {
    font-size: 15px;
    padding:0 10px;
    max-width:350px;
    min-width:350px;
    border-radius:2px;
    border:1px solid #8E54E9;
}

.gemibrain-fe-usertext {
    border:1px solid #4776E6;
    border-radius:6px;
    font-size:16px;
    color:#555;
    padding:10px;
    height:120px;
    min-width:100%;
    max-width:100%;
    resize:none;
    border-radius:4px;
}
        
.gemibrain-fe-usertext:focus {
    outline: none !important;
    border:1px solid #8E54E9;
    box-shadow: 0 0 3px #719ECE;
}
        
.wtp-button-primary {
    padding:8px 50px 10px;
    background-image: linear-gradient(to right, #4776E6 0%, #8E54E9  51%, #4776E6  100%);
    text-align: center;
    transition: 0.5s;
    color:#fff;
    background-size: 200% auto;
    box-shadow: 0 0 20px #eee;
    font-size:12px;
    font-weight:700;
    border:0;
    border-radius:4px;
}
        
.wtp-button-primary:hover {
    background-position: right center;
    cursor:pointer;
    /* opacity:0.9;*/
}
        
.wtp-button-primary:focus {
    box-shadow: 0px 0px 5px #555;
}
        
.gemibrain-sectionleft {
    float:left;
    width:550px;
    margin-right:15px;
    font-size:15px;
}

.gemibrain-drop-container {
    font-size:14px;
    background: #f9f9f9;
    width:220px;
    display: flex;
    gap: 9px;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    padding: 18px 20px;
    border-radius: 10px;
    border: 2px dashed #dedede;
    color: #444;
    cursor: pointer;
    transition: background .2s ease-in-out, border .2s ease-in-out;
}

.gemibrain-drop-container:hover {
    background: #f0f0f0;
    border-color: #ccc;
}

.gemibrain-drop-container:hover .gemibraindrop-title {
    color: #222;
}

.gemibraindrop-title {
    color: #444;
    font-size: 14px;
    font-weight: bold;
    text-align: center;
    transition: color .2s ease-in-out;
}
        
.gemibrain-fe-file {
    width: 200px;
    font-size: 14px;
}
</style>

<div class="gemibrain-fe-section">
    
    <div style="margin-bottom:35px;">
        <label for="gemibrain-engine" style="display:inline-block;width:140px;margin-right:10px;font-size:15px;">Select AI Engine:</label>
        <select name="gemibrain-engine" id="gemibrain-engine">
            <option value="option-1">Google Gemini Pro 2.5</option>
            <option value="option-2">Google Gemini Pro Vision 2.5 (free bonus)</option>
            <option value="option-3">ChatGPT-4.1 (free bonus)</option>
        </select>
    </div>


    <div class="gemibrain-sectionleft" style="">
        <textarea id="gemibrain-fe-usertext" class="gemibrain-fe-usertext" placeholder="Hello, how can I assist you today?" name="gemibrain-fe-usertext" rows="5" maxlength="3000" minlength="30" required></textarea>
            
        <div style="margin-top:10px;margin-bottom:10px;">
            <button type="button" id="gemibrain-fe-userbtn" class="wtp-button-primary">SUBMIT</button>
        </div>
        
        
        <!--START RESPONSE -->
        <style>
            .gemibrain-none {
                display:none;
            }
            .gemibrain-response {
                margin-top:25px;
                margin-bottom:10px;
            }
            
            .gemibrain-imgchat {
                float:left;
                margin:0 20px 0 0;
                width:36px;
                background:#fff;
                z-index:9999;
            }
            .gemibrain-imgchat img {
                /* border-radius:50%; */
                width:36px;
                height:36px;
                display:block;
                animation-name: gemibrainopacity;
                animation-duration: 1s;
            }
            
            .gemibrain-chat {
                background:#0092ff;
                padding:0px 14px;
                border-radius:6px;
                color:#fff;
                font-size:15px;
                max-width:460px;
                display: inline-block;
                position: relative;
                animation-name: gemibrainopacity;
                animation-duration: 1s;
            }
            
            .gemibrain-chat p {
                font-size:14px;
            }
            
            @keyframes gemibrainopacity {
                from {opacity: 0.5;}
                to {opacity: 1;}
            }
            
            .tri-right.left-top:before {
                content: ' ';
                position: absolute;
                width: 0;
                height: 0;
                left: -15px;
                top: 10px;
                bottom: auto;
                border: 10px solid;
                border-color: #0092ff #0092ff transparent transparent;
            }
        </style>
        
        
        <div id="gemibrain-loading"></div>
        <div id="gemibrain-box" class="gemibrain-none">
            <div id="gemibrain-resultbox"></div>
            <div style="clear:both;"></div>
        </div>
        <!--END RESPONSE -->
        
    </div><!--END .gemibrain-sectionleft -->
    
    
        <div class="gemibrain-advsetting" id="gemibrain-boxsetting">
            <div style="font-size:14px;font-weight:600;margin-bottom:15px;">Advanced Setting</div>
            
            <label for="gemibrain-fe-temp" style="width:120px;margin-right:10px;font-size:14px;">Temperature:</label>
            <input type="range" class="gemibrain-fe-temp" name="gemibrain-fe-temp" id="gemibrain-fe-temp" value="8" min="1" max="9" oninput="tempValue.innerText = '0.' + this.value">
            <span id="tempValue">0.8</span>
            
            <div style="height:10px;"></div>
            <label for="gemibrain-fe-tokens" style="width:120px;margin-right:10px;font-size:14px;">Max. Tokens:</label>
            <input disabled type="range" class="gemibrain-fe-tokens" name="gemibrain-fe-tokens" id="gemibrain-fe-tokens" value="32768" min="2048" max="32768" oninput="tokenValue.innerText = this.value">
            <span id="tokenValue">32768</span>
            <br><br>
            <span style="font-size:13px;font-style:italic;line-height:1.1em;">* GemiBrain will now always use Maximum Tokens</span>
        </div>
        
        <style>
            .gemibrain-advsetting {
                background:#f5f5f5;
                border:1px solid #e0e0e0;
                padding:15px;
                width:240px;
                float:left;
                color:#5e5e5e;
            }
            
            .gemibrain-advsetting input[type="range"] {
                width:90px;
                font-size:12px;
                height: 14px;
                vertical-align:middle;
                margin-right:15px;
            }
            
            .gemibrain-advsetting span {
                font-size:13px;
            }
        </style>
    
    <div id="gemibrain-boxfile">
        <label for="gemibrain-fe-file" class="gemibrain-drop-container" id="gemibrain-dropcontainer">
        <span class="gemibraindrop-title">Drop files here</span>
        or
        <div style="margin:0 auto !important;text-align:center;">
            <input type="file" class="gemibrain-fe-file" id="gemibrain-fe-file" name="gemibrain-fe-file" accept="image/jpeg,image/gif,image/png" />
        </div>
        </label>
    </div>
        
    <div style="clear:both;"></div>

</div><!--gemibrain-fe-section-->


    <script>
        document.getElementById( 'gemibrain-fe-userbtn' ).addEventListener( 'click', function ( event ) {
		    
        event.preventDefault();
		    
        var tfcheck = document.getElementById('gemibrain-fe-usertext').value;
        
        if(tfcheck.length<10) {
            window.alert ("Enter your message on the textarea, MINIMUM 10 characters.");
        } else {
			
        var tftextInput = document.getElementById( 'gemibrain-fe-usertext' );
        var tfengineInput = document.getElementById( 'gemibrain-engine' );
        var tffileInput = document.getElementById( 'gemibrain-fe-file' );
        
        var tftempInput = document.getElementById( 'gemibrain-fe-temp' );
        var tftokensInput = document.getElementById( 'gemibrain-fe-tokens' );
        
        var tfbox = document.getElementById( 'gemibrain-box' );
        var tfpostbox = document.getElementById('gemibrain-resultbox');
		
        var tfloadingpict = document.getElementById( 'gemibrain-loading' );
        
        var tfajaxurl = '<?php echo admin_url( 'admin-ajax.php' ); ?>';
        
        if (tfengineInput.value === "option-2") {
            
            var selectedFiles = tffileInput.files;
            
            if (selectedFiles.length === 0) {
                
                window.alert ("Please input your File");
                
            } else {
                
                var sizecheck = document.getElementById('gemibrain-fe-file').files[0].size;
                
                if (sizecheck > 2500000) {
                    window.alert ("File is too big! Maximum 2.5 MB");
                } else {
                    
                tfloadingpict.innerHTML = '<img src="https://d2c136330chs5t.cloudfront.net/AITools/freshai-loading-1.gif" style="margin-top:15px;" width="32" height="32">';
                tfloadingpict.classList = 'downloading';
                
                var tfxhttp = new XMLHttpRequest();
                var tfformData = new FormData();
                tfformData.append( 'action', 'gemibrain_vision' );
                tfformData.append( 'gemibrainuserchat', tftextInput.value );
		        tfformData.append( 'gemibrainuserengine', tfengineInput.value );
		        tfformData.append( 'gemibrainusertemp', tftempInput.value );
		        tfformData.append( 'gemibrainusertoken', tftokensInput.value );
		        tfformData.append( 'gemibrainuserfile', tffileInput.files[0]);
		        
		        tfxhttp.open( "POST", tfajaxurl );
                tfxhttp.send( tfformData );
                
                tfxhttp.onreadystatechange = function () {
			        if ( this.readyState === 4 && this.status === 200 ) {
				    var tfdata = JSON.parse( this.responseText );
				    if ( tfdata.success === true ) {
					    tfloadingpict.classList.add( 'gemibrain-updated' );
					    tfloadingpict.innerHTML = '';
					    tfbox.classList.remove( 'gemibrain-none' );
					    tfbox.classList.add( 'gemibrain-display' );
					    tfpostbox.innerHTML = tfdata.tfallcontent;
				    } else {
					    tfloadingpict.classList.add( 'error' );
					    tfloadingpict.innerHTML = tfdata.data;
				    }
			        }
                };
        
                }//END sizecheck
                
            }
            
        } else {
            
            tfloadingpict.innerHTML = '<img src="https://d2c136330chs5t.cloudfront.net/AITools/freshai-loading-1.gif" style="margin-top:15px;" width="32" height="32">';
            tfloadingpict.classList = 'downloading';
        
            var tfxhttp = new XMLHttpRequest();
            var tfformData = new FormData();
            tfformData.append( 'action', 'gemibrain_apiaction' );
            tfformData.append( 'gemibrainuserchat', tftextInput.value );
		    tfformData.append( 'gemibrainuserengine', tfengineInput.value );
		    tfformData.append( 'gemibrainusertemp', tftempInput.value );
		    tfformData.append( 'gemibrainusertoken', tftokensInput.value );
		    
		    tfxhttp.open( "POST", tfajaxurl );
            tfxhttp.send( tfformData );
            
            tfxhttp.onreadystatechange = function () {
			if ( this.readyState === 4 && this.status === 200 ) {
				var tfdata = JSON.parse( this.responseText );
				if ( tfdata.success === true ) {
					tfloadingpict.classList.add( 'gemibrain-updated' );
					tfloadingpict.innerHTML = '';
					tfbox.classList.remove( 'gemibrain-none' );
					tfbox.classList.add( 'gemibrain-display' );
					tfpostbox.innerHTML = tfdata.tfallcontent;
				} else {
					tfloadingpict.classList.add( 'error' );
					tfloadingpict.innerHTML = tfdata.data;
				}
			}
            };
        }//END tfengineInput.value
			
        
        
        }//END CHECK IF EMPTY
        } );
    </script>


    <script>
        document.getElementById('gemibrain-engine').addEventListener('change', function() {
        var value = this.value;
        var second_section = document.getElementById('gemibrain-dropcontainer');
        var third_section = document.getElementById('gemibrain-boxsetting');
        
        if (value === 'option-2') {
            // displaying #second-section
            second_section.style.display = '';
            third_section.style.display = 'none';
        } else {
            // hiding #second-section
            second_section.style.display = 'none';
            third_section.style.display = '';
        }
        });

        // Hide the #third-section by default
        document.getElementById('gemibrain-dropcontainer').style.display = 'none';
    </script>
    
    
    <script>
        const dropContainer = document.getElementById("gemibrain-dropcontainer")
        const fileInput = document.getElementById("gemibrain-fe-file")

        dropContainer.addEventListener("dragover", (e) => {
            // prevent default to allow drop
            e.preventDefault()
        }, false)

        dropContainer.addEventListener("dragenter", () => {
            dropContainer.classList.add("drag-active")
        })

        dropContainer.addEventListener("dragleave", () => {
            dropContainer.classList.remove("drag-active")
        })

        dropContainer.addEventListener("drop", (e) => {
            e.preventDefault()
            dropContainer.classList.remove("drag-active")
            fileInput.files = e.dataTransfer.files
        })
    </script>
